/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.rest;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchGuardSSLInfoAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final SearchGuardKeyStore sgks;
    final PrincipalExtractor principalExtractor;
    private final Path configPath;
    private final Settings settings;

    public SearchGuardSSLInfoAction(Settings settings, Path configPath, RestController controller, SearchGuardKeyStore sgks, PrincipalExtractor principalExtractor) {
        this.settings = settings;
        this.sgks = sgks;
        this.principalExtractor = principalExtractor;
        this.configPath = configPath;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/sslinfo"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final Boolean showDn;
            final Boolean showServerCerts;
            final Boolean showFullServerCerts;
            {
                this.showDn = request.paramAsBoolean("show_dn", Boolean.FALSE);
                this.showServerCerts = request.paramAsBoolean("show_server_certs", Boolean.FALSE);
                this.showFullServerCerts = request.paramAsBoolean("show_full_server_certs", Boolean.FALSE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(SearchGuardSSLInfoAction.this.settings, SearchGuardSSLInfoAction.this.configPath, request, SearchGuardSSLInfoAction.this.principalExtractor);
                    X509Certificate[] certs = sslInfo == null ? null : sslInfo.getX509Certs();
                    X509Certificate[] localCerts = sslInfo == null ? null : sslInfo.getLocalCertificates();
                    builder.startObject();
                    builder.field("principal", sslInfo == null ? null : sslInfo.getPrincipal());
                    builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
                    if (this.showDn == Boolean.TRUE) {
                        builder.field("peer_certificates_list", certs == null ? null : (Iterable)Arrays.stream(certs).map(c -> c.getSubjectDN().getName()).collect(Collectors.toList()));
                        builder.field("local_certificates_list", localCerts == null ? null : (Iterable)Arrays.stream(localCerts).map(c -> c.getSubjectDN().getName()).collect(Collectors.toList()));
                    }
                    builder.field("ssl_protocol", sslInfo == null ? null : sslInfo.getProtocol());
                    builder.field("ssl_cipher", sslInfo == null ? null : sslInfo.getCipher());
                    builder.field("ssl_openssl_available", false);
                    builder.field("ssl_openssl_version", -1);
                    builder.field("ssl_openssl_version_string", (String)null);
                    builder.field("ssl_openssl_non_available_cause", "Not supported any longer");
                    builder.field("ssl_openssl_supports_key_manager_factory", false);
                    builder.field("ssl_openssl_supports_hostname_validation", false);
                    if (this.showServerCerts == Boolean.TRUE || this.showFullServerCerts == Boolean.TRUE) {
                        if (SearchGuardSSLInfoAction.this.sgks != null) {
                            builder.field("http_certificates_list", (Iterable)SearchGuardSSLInfoAction.this.generateCertDetailList(SearchGuardSSLInfoAction.this.sgks.getHttpCerts(), this.showFullServerCerts));
                            builder.field("transport_certificates_list", (Iterable)SearchGuardSSLInfoAction.this.generateCertDetailList(SearchGuardSSLInfoAction.this.sgks.getTransportCerts(), this.showFullServerCerts));
                        } else {
                            builder.field("message", "keystore is not initialized");
                        }
                    }
                    builder.field("ssl_provider_http", SearchGuardSSLInfoAction.this.sgks.getHTTPProviderName());
                    builder.field("ssl_provider_transport_server", SearchGuardSSLInfoAction.this.sgks.getTransportServerProviderName());
                    builder.field("ssl_provider_transport_client", SearchGuardSSLInfoAction.this.sgks.getTransportClientProviderName());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    private List<Map<String, String>> generateCertDetailList(X509Certificate[] certs, boolean fullChain) {
        if (certs == null) {
            return null;
        }
        return Arrays.stream(certs).limit(fullChain ? (long)certs.length : 1L).map(cert -> {
            String issuerDn = cert != null && cert.getIssuerX500Principal() != null ? cert.getIssuerX500Principal().getName() : "";
            String subjectDn = cert != null && cert.getSubjectX500Principal() != null ? cert.getSubjectX500Principal().getName() : "";
            String san = "";
            try {
                san = cert != null && cert.getSubjectAlternativeNames() != null ? cert.getSubjectAlternativeNames().toString() : "";
            }
            catch (CertificateParsingException e) {
                this.log.error("Issue parsing SubjectAlternativeName:", (Throwable)e);
            }
            String notBefore = cert != null && cert.getNotBefore() != null ? cert.getNotBefore().toInstant().toString() : "";
            String notAfter = cert != null && cert.getNotAfter() != null ? cert.getNotAfter().toInstant().toString() : "";
            return ImmutableMap.builder().put((Object)"issuer_dn", (Object)issuerDn).put((Object)"subject_dn", (Object)subjectDn).put((Object)"san", (Object)san).put((Object)"not_before", (Object)notBefore).put((Object)"not_after", (Object)notAfter).build();
        }).collect(Collectors.toList());
    }

    public String getName() {
        return "Search Guard SSL Info";
    }

    static /* synthetic */ Logger access$400(SearchGuardSSLInfoAction x0) {
        return x0.log;
    }
}

